--
-- createObjRelSchema.sql
--
-- Connect to the database as hr/hr
-- Create an object type called AddressType whose attributes are scalars
CREATE TYPE AddressType AS OBJECT
(
  street VARCHAR2(40),
  city   VARCHAR2(20),
  state  CHAR(2),
  zip    VARCHAR2(10)
);
/

-- Create a second type called EmployeeType, which is also an object type but has 
-- an empaddr attribute of object type AddressType
CREATE TYPE EmployeeType AS OBJECT
(
  employee_id      NUMBER,
  last_name        VARCHAR2(20),
  salary           NUMBER,
  employee_address AddressType
);
/

-- Create EmployeeListType, which is a collection type whose elements are of 
-- EmployeeType:
CREATE TYPE EmployeeListType AS TABLE OF EmployeeType;
/

-- Create table dept1 with an object type column AddressType and a collection type 
-- column EmployeeListType:
CREATE TABLE dept1
(
  deptno   NUMBER,
  deptname VARCHAR2(20),
  deptaddr AddressType,
  emplist  EmployeeListType
)
NESTED TABLE emplist STORE AS emplist_table;

-- Insert a row into dept1
INSERT INTO dept1 VALUES
( 
  120,
  'Treasury',
  AddressType('2004 Charade Rd', 'Seattle', 'WA', '98199'),
  EmployeeListType
  (
    EmployeeType
    (
      1, 
      'Mehta', 
      6000,
      AddressType('500 Main Road', 'Seattle', 'WA', '98199')
    )
  )
);
